/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.store.BitMap;

public class RAShadowFile {
    final Database database;
    final String pathName;
    final Storage source;
    RandomAccessFile dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    HsqlByteArrayOutputStream byteArrayOutputStream = new HsqlByteArrayOutputStream(new byte[0]);

    RAShadowFile(Database database, Storage storage, String string, long l, int n) {
        this.database = database;
        this.pathName = string;
        this.source = storage;
        this.pageSize = n;
        this.maxSize = l;
        int n2 = (int)(l / (long)n);
        if (l % (long)n != 0L) {
            ++n2;
        }
        this.bitMap = new BitMap(n2);
    }

    void copy(long l, int n) throws IOException {
        if (!this.zeroPageSet) {
            this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (l >= this.maxSize) {
            return;
        }
        long l2 = l + (long)n;
        int n2 = (int)(l / (long)this.pageSize);
        int n3 = (int)(l2 / (long)this.pageSize);
        if (l2 % (long)this.pageSize == 0L) {
            --n3;
        }
        while (n2 <= n3) {
            this.copy(n2);
            ++n2;
        }
    }

    private void copy(int n) throws IOException {
        if (this.bitMap.set(n) == 1) {
            return;
        }
        long l = (long)n * (long)this.pageSize;
        int n2 = this.pageSize;
        if (this.maxSize - l < (long)this.pageSize) {
            n2 = (int)(this.maxSize - l);
        }
        try {
            if (this.dest == null) {
                this.open();
            }
            long l2 = this.dest.length();
            byte[] byArray = new byte[this.pageSize + 12];
            this.byteArrayOutputStream.setBuffer(byArray);
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(l);
            this.source.seek(l);
            this.source.read(byArray, 12, n2);
            this.dest.seek(l2);
            this.dest.write(byArray, 0, byArray.length);
        }
        catch (Throwable throwable) {
            this.bitMap.unset(n);
            this.close();
            this.database.logger.appLog.logContext(1, "pos" + l + " " + n2);
            throw FileUtil.toIOException(throwable);
        }
    }

    private void open() throws IOException {
        this.dest = new RandomAccessFile(this.pathName, "rws");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.getFD().sync();
            this.dest.close();
            this.dest = null;
        }
    }

    public static void restoreFile(String string, String string2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(string2, "rw");
        while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
            int n = randomAccessFile.readInt();
            long l = randomAccessFile.readLong();
            byte[] byArray = new byte[n];
            randomAccessFile.read(byArray, 0, byArray.length);
            randomAccessFile2.seek(l);
            randomAccessFile2.write(byArray, 0, byArray.length);
        }
        randomAccessFile.close();
        randomAccessFile2.close();
    }
}

