import java.sql.*;

class DBVerbindung {
    
    /**
     * Eine Testmethode, die eine einfache Anfrage an die Datenbank stellt und das Ergebnis auf die Konsole ausgibt.
     * Ist dazu ausgeleht, vier verschiedene DB-Typen zu testen (SQLite, MS Access, Libre/Open Office Base, MySQL).
     * Je nach Typ laeuft das Herstellen der Verbidnung etwas anders ab, auch die SQL-Syntax ist je nach Typ leicht
     * unterschiedlich, ws die Anfuehrungszeichen um Tabellen- und Spaltenbezeichner bei der Abfrage betrifft.
     * 
     * @param typ Auswahlkriterium dafuer, welche Datenbank getestet werden soll (zulaessig nur: sqlite, access, base, mysql)
     */
    public void test(String typ) {
        String anfragestring = "";
        
        //if (typ == "sqlite")        anfragestring = "SELECT Instrument FROM person, band WHERE Stil='Gothic' AND person.Bandname = band.Bandname;";
        if      (typ == "sqlite")   anfragestring = "SELECT DISTINCT Instrument FROM [person], [band] WHERE Stil='Gothic' AND [person].Bandname = [band].Bandname;";
        else if (typ == "access")   anfragestring = "SELECT DISTINCT Instrument FROM [person], [band] WHERE (Stil='Gothic') AND [person].Bandname = [band].Bandname;";
        else if (typ == "base")     anfragestring = "SELECT DISTINCT \"Instrument\" FROM \"person\", \"band\" WHERE \"Stil\"='Gothic' AND \"person\".\"Bandname\" = \"band\".\"Bandname\";";
        else if (typ == "mysql")    anfragestring = "SELECT DISTINCT Instrument FROM person, band WHERE Stil='Gothic' AND person.Bandname = band.Bandname;";

       
        Connection conn = null;
        // 1. Treiber laden und 2. Herstellen einer Verbindung mit der Datenbank
        if      (typ == "sqlite")   conn = DBVerbindungsgeber.verbindungHerstellen("sqlite", pfadZumOberverzeichnis() + "musikdemo-datenbank/musikgruppen.sqlite", null,null); 
        else if (typ == "access")   conn = DBVerbindungsgeber.verbindungHerstellen("access", pfadZumOberverzeichnis() + "musikdemo-datenbank/musikgruppen.mdb",    null,null); 
        else if (typ == "base")     conn = DBVerbindungsgeber.verbindungHerstellen("base",   pfadZumOberverzeichnis() + "musikdemo-datenbank/musik-odb/musik",     "sa",null); 
        else if (typ == "mysql")    conn = DBVerbindungsgeber.verbindungHerstellen("mysql",  "herr-rau.de/d017169f",                                               "d017169f", "SMAxDFmMypct37Bq"); //auch mit IP-Adresse statt Domain+TLD, z.B: 127.0.0.1

        
        try {
            // 3. Erzeugen eines Statements durch das Verbindungs-Objekt
            Statement stmt = conn.createStatement();            
            // 4. Abrufen der Ergebnismenge der (in diesem Fall: vorbereiteten) Anfrage
            ResultSet rset = stmt.executeQuery(anfragestring);
            // 5. Durchgehen der Ergebnismenge, solange es jeweils ein naechstes Ergebnis gibt
            while (rset.next()){
                ausgeben(rset.getString("Instrument"));     //mit getString- bzw. getInt-Methoden des Ergebnismengen-Objekts jeweils die Daten herausholen
                //ausgeben(rset.getString("Bandname"));
                //ausgeben(""+rset.getInt("Geburtsjahr"));
                //ausgeben(rset.getString("Vorname"));
                //ausgeben(rset.getString("Nachname"));
            }
            // 6. Ergebnismenge schliessen
            rset.close();
            // 7. Statement schliessen
            stmt.close();
            // 8. Verbindung schliessen     
            conn.close();
            ausgeben("Abgemeldet.\n");
        } catch (Exception e) {
            ausgeben(e.toString());
        }

    }    
    
    /**
     * Diese Methode gibt den absoluten Pfad zum Oberverzeichnis des aktuellen Ordners zurueck.
     * Zunaechst wird der Pfad zum aktuellen Verzeichnis ermittelt, aber *ohne* das Verzeichnis selbst.
     * Wenn sich die .class-Datei also im Order "C:\Projekte BlueJ\Projekt42\" befindet, gibt die Methode
     * "C:\Projekte BlueJ" zurueck, plus einem angehaengten "/" ("\\" ginge auch)
     * (Dabei wird in einem Zwischenschritt der Pfad "C:\Projekte%20BlueJ" ermittelt und dann in UTF 8 umgeformt.)
     * 
     * @return der Pfad zum Verzeichnis, in dem diese .class-Datei liegt, ohne dieses Verzeichnis selbst!
     */
    //http://stackoverflow.com/questions/16076911/how-to-find-absolute-path-from-a-relative-path-in-file-system
    private String pfadZumOberverzeichnis(){
        java.security.ProtectionDomain pd = getClass().getProtectionDomain(); //        java.security.ProtectionDomain pd =DBVerbindung.class.getProtectionDomain();
        if ( pd == null ) return null;
        java.security.CodeSource cs = pd.getCodeSource();
        if ( cs == null ) return null;
        java.net.URL url = cs.getLocation();
        if ( url == null ) return null;
        java.io.File f = new java.io.File( url.getFile() );
        if (f == null) return null;
    
        String pfad = "";
        try {
            pfad = f.getParentFile().getAbsolutePath();         // Ermitteln des Pfades zum Oberverzeichnis
            pfad = java.net.URLDecoder.decode(pfad, "utf-8");   // Rueckverwandeln von als "%20" dargestellten evtl. Leerzeichen und anderen Sonderzeichen
        } catch (Exception e) { }
        ausgeben("\nAkt. Verzeichnis: "+System.getProperty("user.dir"));
        ausgeben("Absoluter Pfad:  " +pfad);
        return pfad + "/";
        //wenn stattdessen "" zurueckgegeben wird, handelt es sich um einen rein relativen Pfad
        //wenn stattdessen zurueckgegeben wird "J:/TdI 2013/DEMO_Tester" + "/", handelt es sich um einen absoluten Pfad
    }
    
    private void ausgeben(String s) {
        DBVerbindungsgeber.ausgeben(s);
    }

}