import java.sql.*;

class DBVerbindungsgeber {
    static Fenster f = new Fenster();
    
    /**
     * Stellt eine Verbindung zu einer Datenbank her.
     * 
     * @param typ       dient als Auswahlkriterium fuer den passenden Treiber und das passende praefix zum jeweiligen Datenbanktyp
     * @param datenbank der Pfad zur Datenbank; kann absolut sein oder relativ zum aktiven Java user.dir - das leider alles moegliche sein kann (in BlueJ: das Projektverzeichnis; als .jar: das Verzeichnis mit dem .jar-Archiv darin, je nach Aufrufort)
     * @param user      der Benutzername fuer die Datenbank; kann oft auch null oder "" oder irgendwas sein
     * @param kennwort  das Passwort fuer die Datenbank; kann oft auch null oder "" oder irgendwas sein
     * @return          die aufgebaute Verbindung zur Datenbank
     */
    public static Connection verbindungHerstellen(String typ, String datenbank, String user, String kennwort) {
        ausgeben("Ich suche nach der Datenbank in: \n"+datenbank);
        ausgeben("Verbindung zu "+typ+" wird versucht.");

        String treiber = "";
        String praefix = "";

        if (typ=="mysql") {
            //user und kennwort werden verwendet
            treiber = "com.mysql.jdbc.Driver";          // z.B. aus: mysql-connector-java-5.1.25-bin.jar
            praefix = "jdbc:mysql://";            
        }
        else if (typ=="sqlite") {
            //user und kennwort spielen keine Rolle
            treiber = "org.sqlite.JDBC";                // z.B. aus: sqlite-jdbc-3.7.2.jar
            praefix = "jdbc:sqlite:";  
        }
        else if (typ=="access") {
            //user und kennwort spielen keine Rolle
            treiber = "sun.jdbc.odbc.JdbcOdbcDriver";   // fkt. nur bei Windows mit installiertem Access, Treiber ist bei Java dabei
            praefix = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=";
        }
        else if (typ =="base") {
            //user muss "sa" sein, kennwort spielt keine Rolle; funktioniert nur bei *entpackten* und korrekt umbenannten .odb-Dateien
            treiber = "org.hsqldb.jdbcDriver";          // z.B. aus: hsqldb.jar
            praefix="jdbc:hsqldb:"; 
        }
        else {
            ausgeben("Unbekannter DB-Typ."); return null;
        }

        
        try {
            //1. Passenden Treiber laden
            Class.forName(treiber);
            //2. Verbindung zur DB erstellen
            Connection c = DriverManager.getConnection(praefix+datenbank, user, kennwort);
            ausgeben("Verbindung zu "+typ+" steht.");
            return c;
        } catch (Exception e) {
            ausgeben("Fehler beim Erstellen der Verbindung: "+e);
            return null;
        }
    }

    /**
     * Dient zur Ausgabe eines Strings in einem assoziierten Fenster. 
     * Das ist nur da, damit man die Ausgaben nicht nur auf der Konsole mitlesen kann.
     * 
     * @param s Der auszugebende String.
     */
    public static void ausgeben(String s) {
        f.ausgeben(s);
        System.out.println(s);
    }


 

}