<?php
/*
Plugin Name: Line Numbers for Poems Shortcode
Plugin URI: http://www.herr-rau.de
Description: A simple plugin that allows line numbers for poems (only). Usage [poem]...[/poem], with options start=x and modulo = y. Lines or paragraphs marked [title]...[/title], [author]...[/author] or [uncounted]...[/uncounted] are not counted.
Version: 1.0
Author: Thomas Rau
Author URI: http://www.herr-rau.de
License: http://creativecommons.org/licenses/by-sa/3.0/
*/

// Thanks to @texttheater for setting me on the way

/*
Usage:
[poem]...[/poem]

Result:
Every non-empty line ending with <br /> or </p> counts as a single line.
Line numbers line up, even with a mix of linebreaks and paragraphs (for stanzas).
Lines or paragraphs marked [uncounted]...[/uncounted] are not counted

Options:
[poem start=x modulo=y] start with line number y, print line numbers %y==0
(default: start with 1, print 5, 10, 15...)

Limitations:
Poem must not begin with two line breaks. Number alignment works only with <p> and <br/> tags, not headers.
*/

// Register style sheet.

add_action( 'wp_enqueue_scripts', 'register_plugin_styles' );
function register_plugin_styles() {
	wp_register_style( 'line-numbers-for-poems', plugins_url( 'line-numbers-for-poems/css/line-numbers-for-poems.css' ) );
	wp_enqueue_style( 'line-numbers-for-poems' );
}


//Plugin proper

function uncounted_shortcode($atts, $content = null) {
	return '<span class="lnpUncounted">'.$content.'</span>';
}
function title_shortcode($atts, $content = null) {
	return '<span class="lnpUncountedTitle">'.$content.'</span>';
}
function author_shortcode($atts, $content = null) {
	return '<span class="lnpUncountedAuthor">'.$content.'</span>';
}

function poem_shortcode($atts, $content = null) {
	extract( shortcode_atts( array(
		'start' => 1,
		'modulo' => 5,
	), $atts ) );
	$content = do_shortcode( $content ); #necessary for nested non-recursive shortcodes
	$content = trim($content); #necessary if opening part of shortcode is in line of its own
	return '<table class="lnp"><tr><td class="lnpNumbers"><p>'."\n".lineNumbers($content, $start, $modulo).'</p></td><td class = "lnpPoem"><p>'."\n" . $content . '</p></td></tr></table>';
}

function lineNumbers( $text, $start, $modulo ) {
	$lineno = $start-1;
	$lines = explode( "\n", $text ) ;
	$output = '';

	#necessary when opening part of shortcode is in line of its own
	if (startsWith($text,"<br />")) {
		$output .= '<br />';
	}

	foreach ($lines as $line)
	{
		if ($line !== "<br />") #Sonderfall bei nicht anschliessendem Tag
		{
			if (!startsWith($line,'<span class="lnpUn') && !startsWith($line,'<p><span class="lnpUn')) 
			{				
				$lineno++; 
				// line counted and displayed
				if ($lineno%$modulo==0) 
				{
					$output .= $lineno."<br />";
				} 
				else
				// line counted, not displayed
				{
					$output .= ""."<br />";
				}
			}
			else
			// line not counted, and not displayed
			{
				$output .= ""."<br />";
			}
		}
		if (endsWith($line,"</p>"))
		{		
			$output .= "</p><p>";
		}					
	} 
	return $output;
}

add_shortcode('poem', 'poem_shortcode');
add_shortcode('author', 'author_shortcode');
add_shortcode('title', 'title_shortcode');
add_shortcode('uncounted', 'uncounted_shortcode');



/*
http://stackoverflow.com/questions/834303/php-startswith-and-endswith-functions
http://creativecommons.org/licenses/by-sa/3.0/
by MrHus
*/
function startsWith($haystack, $needle)
{
     $length = strlen($needle);
     return (substr($haystack, 0, $length) === $needle);
return true;
}

/*
http://stackoverflow.com/questions/834303/php-startswith-and-endswith-functions
http://creativecommons.org/licenses/by-sa/3.0/
by MrHus
*/
function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}		
		
?>